#pragma once
#include <map>
#include <string>

#include "Port.h"
#include "GenericValue.h"

namespace CppModelBase
{
    class Model;

    typedef std::map<std::string, Port> PortList;
    typedef std::map<std::string, Model> ModelList;
    typedef std::map<std::string, GenericValue> PropertyList;

    class Model
    {
    private:
    protected:
        PortList ports;
        ModelList models;
        PropertyList properties;

        virtual nlohmann::json &CreatePort(std::string name);

    public:
        Model();
        Model(const Model &other);
        Model(Model &&other);

        Model &operator=(const Model &other);
        ~Model();

        PortList &GetPorts();
        PropertyList &GetProperties();

        nlohmann::json &operator[](std::string name);
        nlohmann::json &port(std::string name);

        virtual void Init();
        virtual void RunCyclic(double simulationTime);
        virtual void Finalize();
    };
}
