#include <cppmodel/Simulation.h>

extern "C" {
    #include "BoomControl.h"
}

class BoomControlSimulation : public CppModelBase::Simulation
{
    public:
    BoomControlSimulation()
    {
        name = "BoomControlSimulation";
        time = 10;
        stepSize = 0.01;
    }

    void RunCyclic(double stepTime) override
    {
        int joystickInput = (stepTime / time) * 4000 + 500;
        HydraulicValveOutput_ts outputContext;

        BoomControl(joystickInput, &outputContext);

        inputs["joystickInput"] = joystickInput;
        outputs["Up"] = outputContext.coilUp;
        outputs["Down"] = outputContext.coilDown;

    }
};

int main(void)
{
    BoomControlSimulation simulation;

    simulation.Simulate();

    return 0;
}
