#pragma once

#include <string>
#include <set>
#include <map>
#include "json.hpp"
#include "httplib.h"

namespace CppModelBase
{
    typedef std::set<std::string> SimulationNamesListType;
    typedef std::string AgentInfoType;
    typedef nlohmann::json InputDataType;
    typedef nlohmann::json ParameterDataType;
    typedef nlohmann::json ResultDataType;
    typedef nlohmann::json SimulationDataType;

    class ApiConnector
    {
    private:
        std::string token = "";
        httplib::Server loginServer;

        void GetLoginResult(const httplib::Request &req, httplib::Response &res);
        void AwaitServer();

        void Relogin();

        void OpenBrowser(const std::string &url);

        std::string StartLocalServer();

        std::string ExchangeAuthCodeForToken(const std::string &code);

    public:
        ApiConnector();
        ~ApiConnector();
        std::string GetFirstGroup(std::string token);
        std::string GetHostname();
        unsigned int GetPort();
        std::string GetApiKey();
        void StoreKey(std::string token);
        std::string Login();
        SimulationNamesListType GetSimulations();
        AgentInfoType GetAgent();
        std::string GetVersion();

        SimulationDataType GetSimulationPreexecutionData(std::string simulationName);
        SimulationDataType GetSimulationData(std::string simulationName);
        void PutSimulationData(std::string simulationName, SimulationDataType &simulationData);
    };
}