#pragma once
#include <string>
#include <map>

#include "InputBuffer.h"

namespace CppModelLib
{
    class JsonInput : public CppModelBase::InputBuffer, public CppModelBase::DataAdapter
    {
    private:
        std::map<std::string, std::map<double, nlohmann::json>> data;

        double GetX(double rawPoint);
        double GetY(double rawPoint);

    public:
        JsonInput();
        JsonInput(const JsonInput &other);
        void Init();
        void RunCyclic(double simulationTime);

        nlohmann::json GetInputData();
        // bool Finalize();

        std::string filename = "";
        double Xoffset = 0.;
        double Xscale = 1.;
        double Yoffset = 0.;
        double Yscale = 1.;
    };

}
