#pragma once
#include <memory>
#include <map>

#include "ApiConnector.h"
#include "Model.h"
#include "SimulationInputs.h"
#include "SimulationOutputs.h"

namespace CppModelBase
{
    class Simulation : public Model
    {
    private:
        void Prepare();
        void Conclude();
    protected:
        double stepSize = 1;
        double time = 10;

        SimulationInputs inputs;
        SimulationOutputs outputs;
        nlohmann::json parameters;

        int simulationResult = true;

    public:
        std::string name;

        Simulation();
        ~Simulation();

        double GetTotalTime();
        int GetSimulationResult();

        void Simulate();
    };
}
