#pragma once
#include <vector>
#include <utility>
#include <string>

#include "InputBuffer.h"

namespace CppModelBase
{
    class Simulation;

    typedef std::map<double, nlohmann::json> TimePointList;

    class InputPort
    {
    private:
        double time;
        nlohmann::json currentValue;
        TimePointList points;

        inline void SetPointAt(double selectedTime, nlohmann::json value) { points[selectedTime] = value; };

    public:
        inline operator nlohmann::json() const { return currentValue; };
        // inline &operator nlohmann::json() { return currentValue; };

        // Set current value and update list
        inline InputPort &operator=(const nlohmann::json newValue)
        {
            currentValue = newValue;
            SetPointAt(time, newValue);

            return *this;
        };

        inline nlohmann::json GetPointAt(double selectedTime)
        {
            double key = points.begin()->first;
            for (auto &p : points)
            {
                if (p.first <= selectedTime)
                {
                    key = p.first;
                }
            }
            // return points[selectedTime];
            return points[key];
        };
        inline nlohmann::json &operator[](double selectedTime) { return points[selectedTime]; };

        // Update current value from list
        inline void SetTime(double newTime)
        {
            time = newTime;
            currentValue = GetPointAt(time);
        };

        inline TimePointList &GetPoints() { return points; };
    };
    typedef std::map<std::string, InputPort> InputPortList;

    class SimulationInputs : public InputBuffer
    {
    private:
        std::vector<std::pair<double, PortList>> data;

        InputPortList rawData;
        InputPortList inputPorts;

        double latestCallTime;

    protected:
        void CreateInputPort(std::string name);

        Port &GetPortAtTime(std::string name, double time);

    public:
        SimulationInputs();
        SimulationInputs(const SimulationInputs &other);

        void LoadFrom(DataAdapter &adapter);
        void RunCyclic(double simulationTime);
        Port &operator[](const std::string &name);

        double simulationTotalTime;

        void SetInitialData(nlohmann::json &initialData);
        nlohmann::json ToJson();
    };
}
