#include <cppmodel/Simulation.h>

extern "C"
{
#include "BoomControl.h"
}

class BoomControlSimulation : public CppModelBase::Simulation
{
public:
    bool simulationValid = true;
    BoomControlSimulation()
    {
        name = "BoomControlSimulation";
        time = 10;
        stepSize = 0.01;
    }

    void RunCyclic(double stepTime) override
    {
        int joystickInput = (stepTime / time) * 5000;
        HydraulicValveOutput_ts outputContext;

        BoomControl(joystickInput, &outputContext);

        inputs["joystickInput"] = joystickInput;
        outputs["Up"] = outputContext.coilUp;
        outputs["Down"] = outputContext.coilDown;

        bool upInRange = (outputContext.coilUp == 0) || (outputContext.coilUp >= 300 && outputContext.coilUp <= 700);
        bool downInRange = (outputContext.coilDown == 0) || (outputContext.coilDown >= 300 && outputContext.coilDown <= 700);
        simulationValid &= upInRange && downInRange;

        outputs["CppModel.StepResult"] = (upInRange && downInRange) ? 1 : 0;

    }
};

int main(void)
{
    BoomControlSimulation simulation;

    simulation.Simulate();

    return simulation.simulationValid ? 0 : -1;
}
